%------------------------------------------------------------------------------
% File     : NUM669^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 18b
% Version  : Especial.
% English  : more (suc x) x

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz18b [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v4.1.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :    9 (   0 unit;   6 type;   0 defn)
%            Number of atoms       :   15 (   1 equality;   5 variable)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   10 (   0   ~;   0   |;   0   &;  10   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    8 (   6   :;   0   =)
%            Number of variables   :    3 (   0 sgn;   3   !;   0   ?;   0   ^)
%                                         (   3   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(more,type,(
    more: nat > nat > $o )).

thf(suc,type,(
    suc: nat > nat )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(n_1,type,(
    n_1: nat )).

thf(satz18,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( more @ ( pl @ Xx @ Xy ) @ Xx ) )).

thf(satz4a,axiom,(
    ! [Xx: nat] :
      ( ( pl @ Xx @ n_1 )
      = ( suc @ Xx ) ) )).

thf(satz18b,conjecture,
    ( more @ ( suc @ x ) @ x )).

%------------------------------------------------------------------------------
